﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.Collections.Generic

Public Class MainForm
    Inherits System.Windows.Forms.Form

    ' 此类成员将告诉我们当前在源数据列表框中
    ' 加载的数据的类型。
    Dim genericDataType As Type

    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' 选中 radioQueue 单选按钮。这样将确保创建一个默认
        ' 泛型数据结构。
        genericDataType = GetType(String)
        radioQueue.Checked = True
    End Sub

    Private Sub DataStructure_CheckChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles radioSortedDictionary.CheckedChanged, radioDictionary.CheckedChanged, radioStack.CheckedChanged, radioList.CheckedChanged, radioQueue.CheckedChanged

        ' 清除目标列表框。
        listTargetData.Items.Clear()

        '我们有一个用于该数据结构单选按钮的所有
        '  checkchanged 事件的事件处理程序。现在必须确定哪个单选按钮被选中，以便
        ' 能够创建合适的数据结构并用数据填充。

        If radioQueue.Checked Then
            CreateQueue()
        ElseIf radioList.Checked Then
            CreateList()
        ElseIf radioStack.Checked Then
            CreateStack()
        ElseIf radioDictionary.Checked Then
            CreateDictionary()
        ElseIf radioSortedDictionary.Checked Then
            CreateSortedDictionary()
        End If
    End Sub

#Region "数据生成方法"
    Private Sub radioString_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles radioString.CheckedChanged
        If radioString.Checked Then
            ' 清除源列表框及目标列表框。
            listSourceData.Items.Clear()
            listTargetData.Items.Clear()

            ' 将一些字符串数据添加到源数据列表框。
            listSourceData.Items.Add("NeKeta Argrow")
            listSourceData.Items.Add("Adam Barr")
            listSourceData.Items.Add("Bonnie L. Skelly")
            listSourceData.Items.Add("Rob Caron")
            listSourceData.Items.Add("Angela Barbariol")

            ' 设置我们正在使用的数据类型。
            genericDataType = GetType(String)

            ' 通过模拟 CheckChanged 事件加载现有的数据结构。
            DataStructure_CheckChanged(sender, e)
        End If
    End Sub

    Private Sub radioLong_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles radioLong.CheckedChanged
        If radioLong.Checked Then
            ' 清除源列表框及目标列表框。
            listSourceData.Items.Clear()
            listTargetData.Items.Clear()

            ' 将一些 long 数据添加到源数据列表框。
            Dim l As LongClass
            l = New LongClass(6)
            listSourceData.Items.Add(l)
            l = New LongClass(447)
            listSourceData.Items.Add(l)
            l = New LongClass(780812)
            listSourceData.Items.Add(l)
            l = New LongClass(99)
            listSourceData.Items.Add(l)
            l = New LongClass(-1)
            listSourceData.Items.Add(l)

            ' 设置我们正在使用的数据类型。
            genericDataType = GetType(LongClass)

            ' 通过模拟 CheckChanged 事件加载现有的数据结构。
            DataStructure_CheckChanged(sender, e)
        End If
    End Sub

    Private Sub radioObject_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles radioObject.CheckedChanged
        If radioObject.Checked Then
            ' 清除源列表框及目标列表框。
            listSourceData.Items.Clear()
            listTargetData.Items.Clear()

            ' 将一些 long 数据添加到源数据列表框。
            Dim c As Customer
            c = New Customer("Stefan Hesse", 1)
            listSourceData.Items.Add(c)
            c = New Customer("George Jiang", 2)
            listSourceData.Items.Add(c)
            c = New Customer("Catherine Boeger", 3)
            listSourceData.Items.Add(c)
            c = New Customer("Ivo William Salmre", 4)
            listSourceData.Items.Add(c)
            c = New Customer("Kim Ralls", 5)
            listSourceData.Items.Add(c)

            ' 设置我们正在使用的数据类型。
            genericDataType = GetType(Customer)

            ' 通过模拟 CheckChanged 事件加载现有的数据结构。
            DataStructure_CheckChanged(sender, e)
        End If
    End Sub
#End Region

#Region "Queue 数据结构方法"

    Dim stringQueue As Queue(Of String)
    Dim longQueue As Queue(Of LongClass)
    Dim customerQueue As Queue(Of Customer)

    Private Sub QueueEnqueue(Of ItemType)(ByVal queue As Queue(Of ItemType))
        For i As Integer = 0 To listSourceData.Items.Count - 1
            queue.Enqueue(CType(listSourceData.Items(i), ItemType))
        Next
    End Sub

    Private Sub QueueDisplay(Of ItemType)(ByVal queue As Queue(Of ItemType))
        listTargetData.Items.Clear()
        For Each item As ItemType In queue
            listTargetData.Items.Add(item)
        Next
    End Sub

    Private Sub QueueReverse(Of ItemType)(ByVal queue As Queue(Of itemtype))
        ' 将队列转储到数组。
        Dim o_array(queue.Count - 1) As ItemType
        o_array = queue.ToArray()

        ' 移除队列中的现有项。
        queue.Clear()

        ' 将项按照它们原来在队列中的顺序的相反顺序排入队列。
        For i As Integer = o_array.Length - 1 To 0 Step -1
            queue.Enqueue(o_array(i))
        Next

        ' 使用现有方法将队列中的各项加载到目标列表框。
        LoadQueue(False)
    End Sub

    Private Sub QueueSort(Of ItemType)(ByVal queue As Queue(Of ItemType))
        ' 将队列转储到数组。
        Dim o_array(queue.Count - 1) As ItemType
        o_array = queue.ToArray()

        ' 将数组排序。
        Array.Sort(o_array)

        ' 移除队列中的现有项。
        queue.Clear()

        ' 将项重新添加回队列。
        For i As Integer = 0 To o_array.Length - 1
            queue.Enqueue(o_array(i))
        Next

        ' 使用现有方法将队列中的各项加载到目标列表框。
        LoadQueue(False)
    End Sub

    Private Sub CreateQueue()
        Select Case genericDataType.Name
            Case "String"
                stringQueue = New System.Collections.Generic.Queue(Of String)
                QueueEnqueue(stringQueue)
            Case "LongClass"
                longQueue = New System.Collections.Generic.Queue(Of LongClass)
                QueueEnqueue(longQueue)
            Case "Customer"
                customerQueue = New System.Collections.Generic.Queue(Of Customer)
                QueueEnqueue(customerQueue)
        End Select
    End Sub

    Private Sub ReverseQueue()
        Select Case genericDataType.Name
            Case "String"
                QueueReverse(stringQueue)
            Case "LongClass"
                QueueReverse(longQueue)
            Case "Customer"
                QueueReverse(customerQueue)
        End Select
    End Sub

    Private Sub LoadQueue(Optional ByVal recreate As Boolean = True)
        ' 我们将在此处重新创建队列，以防范它已被清空的情况。
        If recreate Then
            CreateQueue()
        End If

        Select Case genericDataType.Name
            Case "String"
                QueueDisplay(stringQueue)
            Case "LongClass"
                QueueDisplay(longQueue)
            Case "Customer"
                QueueDisplay(customerQueue)
        End Select
    End Sub

    Private Sub EmptyQueue()
        Select Case genericDataType.Name
            Case "String"
                stringQueue.Clear()
            Case "LongClass"
                longQueue.Clear()
            Case "Customer"
                customerQueue.Clear()
        End Select
    End Sub

    Private Sub SortQueue()
        Select Case genericDataType.Name
            Case "String"
                QueueSort(stringQueue)
            Case "LongClass"
                QueueSort(longQueue)
            Case "Customer"
                QueueSort(customerQueue)
        End Select
    End Sub

#End Region

#Region "List 数据结构方法"

    Dim stringList As List(Of String)
    Dim longList As List(Of LongClass)
    Dim customerList As List(Of Customer)

    Private Sub ListAdd(Of ItemType)(ByVal list As List(Of ItemType))
        ' 使用源列表框中的数据填充列表。
        For i As Integer = 0 To listSourceData.Items.Count - 1
            list.Add(CType(listSourceData.Items(i), ItemType))
        Next
    End Sub

    Private Sub ListDisplay(Of ItemType)(ByVal list As List(Of ItemType))
        For i As Integer = 0 To list.Count - 1
            listTargetData.Items.Add(list(i))
        Next
    End Sub

    Private Sub ListReverse(Of ItemType)(ByVal list As List(Of ItemType))
        list.Reverse()
    End Sub

    Private Sub ListSort(Of ItemType)(ByVal list As List(Of ItemType))
        list.Sort()
    End Sub

    Private Sub CreateList()
        Select Case genericDataType.Name
            Case "String"
                stringList = New System.Collections.Generic.List(Of String)
                ListAdd(stringList)
            Case "LongClass"
                longList = New System.Collections.Generic.List(Of LongClass)
                ListAdd(longList)
            Case "Customer"
                customerList = New System.Collections.Generic.List(Of Customer)
                ListAdd(customerList)
        End Select
    End Sub

    Private Sub LoadList(Optional ByVal recreate As Boolean = True)
        '我们将在此处重新创建列表，以防范它已被清空的情况。
        If recreate Then
            CreateList()
        End If

        Select Case genericDataType.Name
            Case "String"
                ListDisplay(stringList)
            Case "LongClass"
                ListDisplay(longList)
            Case "Customer"
                ListDisplay(customerList)
        End Select
    End Sub

    Private Sub EmptyList()
        Select Case genericDataType.Name
            Case "String"
                stringList.Clear()
            Case "LongClass"
                longList.Clear()
            Case "Customer"
                customerList.Clear()
        End Select
    End Sub

    Private Sub ReverseList()
        Select Case genericDataType.Name
            Case "String"
                ListReverse(stringList)
            Case "LongClass"
                ListReverse(longList)
            Case "Customer"
                ListReverse(customerList)
        End Select

        ' 使用现有方法将队列中的各项加载到目标列表框。
        LoadList(False)
    End Sub

    Private Sub SortList()
        Select Case genericDataType.Name
            Case "String"
                ListSort(stringList)
            Case "LongClass"
                ListSort(longList)
            Case "Customer"
                ListSort(customerList)
        End Select

        ' 使用现有方法将队列中的各项加载到目标列表框。
        LoadList(False)
    End Sub

#End Region

#Region "Stack 数据结构方法"

    Dim stringStack As Stack(Of String)
    Dim longStack As Stack(Of LongClass)
    Dim customerStack As Stack(Of Customer)

    Private Sub StackPush(Of ItemType)(ByVal stack As Stack(Of ItemType))
        ' 以源列表框中的数据填充堆栈。
        For i As Integer = 0 To listSourceData.Items.Count - 1
            stack.Push(CType(listSourceData.Items(i), ItemType))
        Next
    End Sub

    Private Sub StackDisplay(Of ItemType)(ByVal stack As Stack(Of ItemType))
        listTargetData.Items.Clear()
        For Each item As Object In stack
            listTargetData.Items.Add(CType(item, ItemType))
        Next
    End Sub

    Private Sub StackReverse(Of ItemType)(ByVal stack As Stack(Of ItemType))
        ' 将堆栈转储到数组。
        Dim o_array(stack.Count - 1) As ItemType
        o_array = stack.ToArray()

        ' 移除堆栈中的现有项。
        stack.Clear()

        ' 将项按照它们原来在堆栈中的顺序的相反顺序压入堆栈。
        For i As Integer = 0 To o_array.Length - 1
            stack.Push(o_array(i))
        Next

        ' 使用现有方法将堆栈中的各项加载到目标列表框。
        LoadStack(False)
    End Sub

    Private Sub StackSort(Of ItemType)(ByVal stack As Stack(Of ItemType))
        ' 将堆栈转储到数组。
        Dim o_array(stack.Count - 1) As ItemType
        o_array = stack.ToArray()

        ' 将数组排序。
        Array.Sort(o_array)

        ' 移除堆栈中的现有项。
        stack.Clear()

        ' 将项重新添加回队列。
        For i As Integer = o_array.Length - 1 To 0 Step -1
            stack.Push(o_array(i))
        Next

        ' 使用现有方法将堆栈中的各项加载到目标列表框。
        LoadStack(False)
    End Sub

    Private Sub CreateStack()
        Select Case genericDataType.Name
            Case "String"
                stringStack = New System.Collections.Generic.Stack(Of String)
                StackPush(stringStack)
            Case "LongClass"
                longStack = New System.Collections.Generic.Stack(Of LongClass)
                StackPush(longStack)
            Case "Customer"
                customerStack = New System.Collections.Generic.Stack(Of Customer)
                StackPush(customerStack)
        End Select

    End Sub

    Private Sub LoadStack(Optional ByVal recreate As Boolean = True)
        ' 我们将在此处重新创建堆栈，以防范它已被清空的情况。
        If recreate Then
            CreateStack()
        End If

        Select Case genericDataType.Name
            Case "String"
                StackDisplay(stringStack)
            Case "LongClass"
                StackDisplay(longStack)
            Case "Customer"
                StackDisplay(customerStack)
        End Select
    End Sub

    Private Sub EmptyStack()
        Select Case genericDataType.Name
            Case "String"
                stringStack.Clear()
            Case "LongClass"
                longStack.Clear()
            Case "Customer"
                customerStack.Clear()
        End Select
    End Sub

    Private Sub ReverseStack()
        Select Case genericDataType.Name
            Case "String"
                StackReverse(stringStack)
            Case "LongClass"
                StackReverse(longStack)
            Case "Customer"
                StackReverse(customerStack)
        End Select
    End Sub

    Private Sub SortStack()
        Select Case genericDataType.Name
            Case "String"
                StackSort(stringStack)
            Case "LongClass"
                StackSort(longStack)
            Case "Customer"
                StackSort(customerStack)
        End Select
    End Sub

#End Region

#Region "Dictionary 数据结构方法"

    Dim stringDictionary As Dictionary(Of String, String)
    Dim longDictionary As Dictionary(Of LongClass, LongClass)
    Dim customerDictionary As Dictionary(Of Customer, Customer)

    Private Sub DictionaryAdd(Of ItemType)(ByVal dictionary As Dictionary(Of ItemType, ItemType))
        ' 以源列表框中的数据填充堆栈。
        For i As Integer = 0 To listSourceData.Items.Count - 1
            ' 由于源列表框中的每个项都是唯一的，因此我们可以使用 
            ' .ToString() 方法获取将作为该项的键的字符串值。
            dictionary.Add( _
                CType(listSourceData.Items(i), ItemType), _
                CType(listSourceData.Items(i), ItemType))
        Next
    End Sub

    Private Sub DictionaryDisplay(Of ItemType)(ByVal dictionary As Dictionary(Of ItemType, ItemType))
        listTargetData.Items.Clear()

        ' 将字典中的每个项添加到目标列表框。
        For Each item As ItemType In dictionary.Keys
            listTargetData.Items.Add(dictionary(item))
        Next
    End Sub

    Private Sub DictionarySort(Of ItemType)(ByVal dictionary As Dictionary(Of ItemType, ItemType))
        ' 项按照它们添加的顺序存储在字典中。
        ' 为了反转字典中项的顺序，我们将把内容复制到一个数组中，然后
        ' 以相反的顺序将它们重新添加到字典中。

        ' 将字典转储到数组。
        Dim o_array(dictionary.Keys.Count - 1) As Object
        Dim i As Integer
        For Each key As ItemType In dictionary.Keys
            o_array(i) = dictionary(key)
            i = i + 1
        Next

        ' 将数组排序。
        Array.Sort(o_array)

        ' 移除字典中的现有项。
        dictionary.Clear()

        ' 将项以它们在排序数组中的顺序排入队列。
        For i = 0 To o_array.Length - 1
            dictionary.Add( _
                CType(o_array(i), ItemType), _
                CType(o_array(i), ItemType))
        Next
    End Sub

    Private Sub DictionaryReverse(Of ItemType)(ByVal dictionary As Dictionary(Of ItemType, ItemType))
        ' 项以它们添加的顺序存储在字典中。
        ' 为了反转字典中项的顺序，我们将把内容复制到一个数组中，然后
        ' 以相反顺序将它们重新添加到字典中。

        ' 将字典转储到数组。
        Dim o_array(dictionary.Keys.Count - 1) As Object
        Dim i As Integer
        For Each item As ItemType In dictionary.Keys
            o_array(i) = dictionary(item)
            i = i + 1
        Next

        ' 移除字典中的现有项。
        dictionary.Clear()

        ' 将项以它们原来在字典中的顺序的相反顺序排入队列。
        For i = o_array.Length - 1 To 0 Step -1
            dictionary.Add( _
            CType(o_array(i), ItemType), _
            CType(o_array(i), ItemType))
        Next
    End Sub

    Private Sub CreateDictionary()
        ' 对于使用键访问数据结构成员的泛型，必须同时提供
        ' 数据结构类型和键的类型。对于此示例，所有键
        ' 都是字符串。
        Select Case genericDataType.Name
            Case "String"
                stringDictionary = New Dictionary(Of String, String)
                DictionaryAdd(stringDictionary)
            Case "LongClass"
                longDictionary = New Dictionary(Of LongClass, LongClass)
                DictionaryAdd(longDictionary)
            Case "Customer"
                customerDictionary = New Dictionary(Of Customer, Customer)
                DictionaryAdd(customerDictionary)
        End Select
    End Sub

    Private Sub LoadDictionary(Optional ByVal recreate As Boolean = True)
        ' 我们将在此处重新创建字典，只是为了防范它已被清空的情况。
        If recreate Then
            CreateDictionary()
        End If

        Select Case genericDataType.Name
            Case "String"
                DictionaryDisplay(stringDictionary)
            Case "LongClass"
                DictionaryDisplay(longDictionary)
            Case "Customer"
                DictionaryDisplay(customerDictionary)
        End Select
    End Sub

    Private Sub EmptyDictionary()
        Select Case genericDataType.Name
            Case "String"
                stringDictionary.Clear()
            Case "LongClass"
                longDictionary.Clear()
            Case "Customer"
                customerDictionary.Clear()
        End Select
    End Sub

    Private Sub ReverseDictionary()
        Select Case genericDataType.Name
            Case "String"
                DictionaryReverse(stringDictionary)
            Case "LongClass"
                DictionaryReverse(longDictionary)
            Case "Customer"
                DictionaryReverse(customerDictionary)
        End Select

        ' 使用现有方法将字典中的各项加载到目标列表框。
        LoadDictionary(False)
    End Sub

    Private Sub SortDictionary()
        Select Case genericDataType.Name
            Case "String"
                DictionarySort(stringDictionary)
            Case "LongClass"
                DictionarySort(longDictionary)
            Case "Customer"
                DictionarySort(customerDictionary)
        End Select

        ' 使用现有方法将字典中的各项加载到目标列表框。
        LoadDictionary(False)
    End Sub

#End Region

#Region "SortedList 数据结构方法"

    Dim stringSorted As SortedList(Of String, String)
    Dim longSorted As SortedList(Of LongClass, LongClass)
    Dim customerSorted As SortedList(Of Customer, Customer)

    Private Sub SortedAdd(Of ItemType)(ByVal sorted As SortedList(Of ItemType, ItemType))
        ' 以源列表框中的数据填充堆栈。
        For i As Integer = 0 To listSourceData.Items.Count - 1
            ' 由于源列表框中的每个项都是唯一的，可以使用
            ' .ToString() 方法获取将作为该项的键的字符串值。
            sorted.Add( _
                CType(listSourceData.Items(i), ItemType), _
                CType(listSourceData.Items(i), ItemType))
        Next
    End Sub

    Private Sub SortedDisplay(Of ItemType)(ByVal sorted As SortedList(Of ItemType, ItemType))
        For Each pair As KeyValuePair(Of ItemType, ItemType) In sorted
            listTargetData.Items.Add(pair.Value)
        Next
    End Sub

    Private Sub SortedReverse(Of ItemType)(ByVal sorted As SortedList(Of ItemType, ItemType))
        ' 项在插入到 SortedDictionary 中时将进行排序，
        ' 因此不能修改 SortedDictionary 中存储的项的顺序。不能以相反顺序将项
        ' 存储在 SortedDictionary 中。

        ' 但是，可以在列表框控件中按相反的顺序显示它们。
        Dim keys As IList(Of ItemType) = sorted.Keys
        For index As Integer = keys.Count - 1 To 0 Step -1
            listTargetData.Items.Add(CType(sorted(keys(index)), ItemType))
        Next
    End Sub

    Private Sub CreateSortedDictionary()
        ' 对于使用键访问数据结构成员的泛型，必须同时提供
        ' 数据结构类型和键的类型。对于此示例，所有键
        ' 都是字符串。

        Select Case genericDataType.Name
            Case "String"
                stringSorted = New SortedList(Of String, String)
                SortedAdd(stringSorted)
            Case "LongClass"
                longSorted = New SortedList(Of LongClass, LongClass)
                SortedAdd(longSorted)
            Case "Customer"
                customerSorted = New SortedList(Of Customer, Customer)
                SortedAdd(customerSorted)
        End Select
    End Sub

    Private Sub LoadSortedDictionary(Optional ByVal recreate As Boolean = True)
        ' 我们将在此处重新创建 SortedDictionary，只是为了防范它已被清空的情况。
        If recreate Then
            CreateSortedDictionary()
        End If

        Select Case genericDataType.Name
            Case "String"
                SortedDisplay(stringSorted)
            Case "LongClass"
                SortedDisplay(longSorted)
            Case "Customer"
                SortedDisplay(customerSorted)
        End Select
    End Sub

    Private Sub EmptySortedDictionary()
        Select Case genericDataType.Name
            Case "String"
                stringSorted.Clear()
            Case "LongClass"
                longSorted.Clear()
            Case "Customer"
                customerSorted.Clear()
        End Select
    End Sub

    Private Sub ReverseSortedDictionary()
        Select Case genericDataType.Name
            Case "String"
                SortedReverse(stringSorted)
            Case "LongClass"
                SortedReverse(longSorted)
            Case "Customer"
                SortedReverse(customerSorted)
        End Select
    End Sub

    Private Sub SortSortedDictionary()
        '由于项是按顺序插入到 SortedDictionary 中的，
        ' 因此不需要用于对此数据结构的内容进行排序的实现。

        ' 使用现有方法将字典中的各项加载到目标列表框。
        LoadSortedDictionary(False)
    End Sub

#End Region

#Region "按钮单击事件"
    Private Sub cmdLoad_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdLoad.Click
        ' 清空目标列表框。
        listTargetData.Items.Clear()

        ' 当单击“Copy”（复制）按钮时，我们想要将数据从
        ' 当前正在使用的泛型数据结构复制到目标列表框。
        If radioQueue.Checked Then
            LoadQueue()
        ElseIf radioList.Checked Then
            LoadList()
        ElseIf radioStack.Checked Then
            LoadStack()
        ElseIf radioDictionary.Checked Then
            LoadDictionary()
        ElseIf radioSortedDictionary.Checked Then
            LoadSortedDictionary()
        End If

    End Sub


    Private Sub cmdEmpty_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdEmpty.Click
        ' 单击“empty”（清空）按钮时，我们希望清空泛型数据结构。
        If radioQueue.Checked Then
            EmptyQueue()
        ElseIf radioList.Checked Then
            EmptyList()
        ElseIf radioStack.Checked Then
            EmptyStack()
        ElseIf radioDictionary.Checked Then
            EmptyDictionary()
        ElseIf radioSortedDictionary.Checked Then
            EmptySortedDictionary()
        End If

        ' 清空目标列表框。
        listTargetData.Items.Clear()
    End Sub


    Private Sub cmdReverse_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdReverse.Click
        ' 清空目标列表框。
        listTargetData.Items.Clear()

        ' 单击“empty”（清空）按钮时，我们希望清空泛型数据结构。
        If radioQueue.Checked Then
            ReverseQueue()
        ElseIf radioList.Checked Then
            ReverseList()
        ElseIf radioStack.Checked Then
            ReverseStack()
        ElseIf radioDictionary.Checked Then
            ReverseDictionary()
        ElseIf radioSortedDictionary.Checked Then
            ReverseSortedDictionary()
        End If
    End Sub


    Private Sub cmdSort_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdSort.Click
        ' 为了使本过程能够工作，数组中包含的项
        ' 必须支持比较。这是由对象通过实现
        ' IComparable 接口完成的。
        ' 有关更多信息，请参见 Customer.vb 中的 Customer 对象定义。

        ' 清空目标列表框。
        listTargetData.Items.Clear()

        ' 单击“empty”（清空）按钮时，我们希望清空泛型数据结构。
        If radioQueue.Checked Then
            SortQueue()
        ElseIf radioList.Checked Then
            SortList()
        ElseIf radioStack.Checked Then
            SortStack()
        ElseIf radioDictionary.Checked Then
            SortDictionary()
        ElseIf radioSortedDictionary.Checked Then
            SortSortedDictionary()
        End If
    End Sub
#End Region


End Class
